#!/bin/bash

set -e

# https://stackoverflow.com/a/246128
SCRIPT_DIR=$( cd -- "$( dirname -- "${BASH_SOURCE[0]}" )" &> /dev/null && pwd )
cd "${SCRIPT_DIR}"

exec qemu-system-x86_64 \
  -machine q35 \
  -cpu qemu64 \
  -smp 1 \
  -m 4096 \
  -accel tcg \
  -global ICH9-LPC.disable_s3=1 \
  -device ich9-ahci,id=sata \
  -drive if=pflash,format=raw,readonly=on,file=code.fd \
  -drive if=pflash,format=raw,file=vars.fd \
  -drive if=none,id=hd0,file=drive.qcow2,format=qcow2 \
  -device ide-hd,bus=sata.1,drive=hd0,bootindex=1 \
  -netdev user,id=net0,hostfwd=tcp:127.0.0.1:2200-:22 \
  -device e1000,netdev=net0 \
  -nographic

